<?=Form::open(null, ['id' => 'widget-filter'])?>
<div class="col-md-12 well">
	<div class="row-fluid">
		<div id="users_js" class="col-xs-2">
			<?=Form::select('users[]', $users, Arr::get($post, 'users'), [
				'class' => 'selectpicker',
				'multiple' => '',
				'style' => 'width: 100%; width: calc(100% - 30px);'
			]);?>
		</div>

		<!-- Link -->
		<div class="col-xs-2" style="margin-left: -15px;">
			<?=Form::input('link', Arr::get($post, 'link'),[
				'class' => 'form-control input-sm',
				'placeholder' => 'Link'
			]) ?>
		</div>

		<!-- Data range -->
		<div class="col-xs-2 input-daterange input-group datepicker-range">
			<?=Form::input('date_start', Arr::get($post, 'date_start'), [
				'id' => 'date_start',
				'class' => 'form-control input-sm',
				'placeholder' => '1901/12/13'
			]); ?>

			<span class="input-group-addon"> / </span>

			<?=Form::input('date_end', Arr::get($post, 'date_end'), [
				'id' => 'date_end',
				'class' => 'form-control input-sm',
				'placeholder' => '2038/01/19'
			]); ?>
		</div>

		<div class="col-xs-2 pull-right">
			<!-- BTN -->
			<?=Form::button('filter', 'Find', [
				'id' => 'filter',
				'class'=>'btn btn-primary pull-right',
				'type'=>'submit'
			]);?>
			<?=Form::button('reset', 'Reset', [
				'class'=>'btn btn-danger pull-right',
				'type'=>'submit',
				'style' => 'margin-right: 10px;'
			]);?>
		</div>
	</div>
</div>
<?=Form::close()?>

<?=$pagination?>
<div class="col-md-12">
    <table class="table table-striped">
        <thead>
            <tr>
                <td style="width: 1px;">Id</td>
                <td>User</td>
                <td>User IP</td>
                <td>Timestamp<br />start</td>
                <td>Time<br />client<br />filter</td>
                <td>Time<br />find<br />clients</td>
                <td>Time<br />find<br />logposts</td>
                <td>Time<br />find<br />logposts (DB)</td>
                <td>Time<br />total</td>
                <td>Client<br />filter</td>
                <td>Clients</td>
                <td>Logpost<br />per<br />page</td>
                <td>Parallel<br />queries<br />(count/time)</td>
                <td>Query</td>
            </tr>
        </thead>
        <tbody>
            <?foreach($logs as $log){?>
                <tr>
                    <td><?=$log['id']?></td>
                    <td><?=$log['username']?></td>
                    <td><?=$log['user_ip']?></td>
                    <td>
                        <?php echo date("Y-m-d H:i:s", strtotime($log['time_start'])-3600);?>
                    </td>
                    <td><?=$log['time_client_filter']?></td>
                    <td><?=$log['time_find_clients']?></td>
                    <td><?=$log['time_find_logposts']?></td>
                    <td><?=$log['time_find_logposts_db']?></td>
                    <td><?=$model->getTimeTotalFormatted($log['time_total'])?></td>
                    <td><?=$model->getCountClientFilterFormatted($log['count_client_filter'])?></td>
                    <td><?=$log['count_find_clients']?></td>
                    <td><?=$log['count_find_logposts']?></td>
                    <td><?=$model->getParallelQueries($log['id'])?></td>
                    <td>
                        <table class="table" style="text-align: left">
                            <?php foreach(json_decode($log['query']) as $key => $item ){ ?>
                                <tr>
                                    <td style="width: 1px;">
                                        <?php echo $key?>
                                    </td>
                                    <td class="wrap-word">
                                        <?php if(is_array($item)){ ?>
                                            <?= json_encode($item); ?>
                                        <?php } else { ?>
                                            <?= $item; ?>
                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        </table>
                    </td>
                    <td></td>
                </tr>
            <?}?>
        </tbody>
    </table>
</div>
<?=$pagination?>

<script>
	$(document).ready(function() {
		var $scopeWidget = $('#users_js');
		var $selectUsers = $('select[name="users[]"]', $scopeWidget);
		$selectUsers.select2({
			placeholder: "User"
		}).data('select2').$container.addClass("input-sm").css('padding', 0);
	});
</script>
<?=View::factory('welcome/v_script')?>